Here’s a tight, actionable read on Darnell Mooney (ATL, WR2) based on the Reddit FF Hound data and expert notes.

Bottom line
- Role: Clear WR2 in a run-heavy ATL offense. Target competition mostly behind him is Drake London; Mooney benefits from being the secondary option but has limited ceiling unless London misses time.
- ADP/value: WR49 at ~128.9 (Best-Ball-ish). Upside score around +2.0 at this ADP — suggests modest value if you draft him as a 4th–5th WR, not a core upside pick.
- Key risk: Injury history (2024) and QB/ offense volatility. Past high production came with Kirk Cousins; not guaranteed to translate to ATL.

2025 fantasy outlook (concise projections)
- Targets: ~90–120 in a full season (floor around 90; ceiling ~120 if London misses time or in a pass-friendly stretch).
- Receiving yardage: roughly 700–1,000 yards (likely closer to 750–900 if London stays healthy and the offense stays run-first).
- TDs: 4–7 touchdowns (range depends on red-zone usage and overall scoring volatility).
- PPR/Fantasy points: ~130–190 fantasy points for the season (roughly 8–12 FPG; floor to mid-range depending on weeks London is healthy).

What Reddit/FF Hound sentiment points to
- Strengths when healthy: In a Cousins-led stretch (Weeks 2–10 with high route share), Mooney posted elite route share (~90.9%), solid targets (7.9 per game), and productive yardage with 5 TDs and ~15.8 FPG. This signals a workable baseline if the offense supports him.
- Why he’s not a slam-dunk WR1: He’s currently the 2nd option on a run-heavy team; his ceiling hinges on London’s availability and overall offense pace. Injury risk from 2024 lingers as a red flag.
- ADP context: Mooney’s ADP hasn’t correctly priced in injury risk or role volatility, per FF Hound. His value is more solid in Best Ball or as a late-round flyer rather than a standout ceiling bet.
- Comparisons/peers: He’s discussed as a safer WR2 type relative to some upside-or-bust WRs; in that space, he’s often grouped with other late-round WR2/WR3 targets. The “WR2 on a run-heavy team” angle is consistently cited as a floor driver but a ceiling limiter.

Actionable drafting notes
- Allocation: Target Mooney as a late-round, distance-to-breakout option. In 12-team or shallower, he’s a solid WR4/flex with reasonable floor; in best-ball, he’s worth a dart throw for upside scenarios.
- Pairing strategy: If you lock London, pair Mooney with a high-upside WR with standalone ceiling (e.g., a safe target anchor plus a big-boom option). If you miss on London, Mooney’s value and weeks-to-week spike potential increase.
- Week-to-week playability: Expect floor weeks in the 6–9 PPR range when the offense stalls; spike weeks if London is limited or absent.
- Injury monitor: Track camp/early-season health risk. A “week-to-week” designation for Mooney’s own availability could juice his value as a later-round add if an opening arises.
- Red flags to watch: Team pace in 2025, QB stability, and offensive schematics. Any shift toward a more pass-heavy approach or increased target share for Mooney would lift his outlook; otherwise, he remains a predictable, low-ceiling WR2.

Key discussion points for drafts
- Is Mooney worth a 4th–6th round pick given WR2 role and injury history? He’s more defensible as a value pick in that range, not a target for ceiling-chasing.
- How much will London’s health dictate Mooney’s target share? The clearest driver of his upside is London missing time or delivering an inefficient season.
- How soon should you pivot if Mooney’s camp reports are concerning? Consider lighter exposure early and pivot to a higher-upside WR if the offense signals pass-heavy developments.

Summary
Darnell Mooney in ATL offers a reliable floor as a WR2 with some weekly spike potential tied to London’s status and overall offensive pace. He’s a value-at-adp pick in the right format (best ball or late-rounding) but not a slam-dunk ceiling player. Monitor camp health and London’s availability closely, as those are the primary levers for his 2025 upside.